/***********
 This module is provided as an example of creating a Node PACKAGE, which could be published to NPM.

 Any modules within subfolders should be made into packages *create a package.json, e.g. by running 'npm init' in the directory).
 Otherwise NPM may clean up subfolders when running npm commands.
 **********/

const omnis_calls = require('omnis_calls');
const fs = require('fs');

let autoSendResponse = true; // Set to false in methods which should not send a response to Omnis when they exit. (e.g. async methods)

/**
 * Implement all of your publicly accessible methods in methodMap.
 */
const methodMap = {

	test: function(param) {
		return {
			unicode: "Fingerspitzengef\xFChl is a German term.\nIt\u2019s pronounced as follows: [\u02C8f\u026A\u014B\u0250\u02CC\u0283p\u026Ats\u0259n\u0261\u0259\u02CCfy\u02D0l]"
		};
	},

	method: function(param) {
		return param;
	},

	readpng: function(param, response) {
		autoSendResponse = false; // This method is asynchronous - we will manually send the response

		fs.readFile(param.path, function (err, data) {
			if (err) throw err;
			omnis_calls.sendResponseBuffer(data, "image/png", response);
		});
	}
};


module.exports = {
	call: function (method, param, response) { // The only requirement of an Omnis module is that it implement this function.

		autoSendResponse = true;

		if (methodMap[method]) {
			const result = methodMap[method](param, response);
			if (autoSendResponse)
				omnis_calls.sendResponse(result, response);
			return true;
		}
		else {
			throw Error("Method '" + method + "' does not exist");
		}

	}
};